import turtle

screen = turtle.Screen()

tyra = turtle.Turtle()
info = turtle.Turtle()
knot = turtle.Turtle()
knot.shape('circle')
knot.hideturtle()

for elem in screen.turtles():
    elem.penup()

def drop(size):
    tyra.forward(size/2)
    tyra.pendown()

    tyra.color('navy', 'skyblue')
    tyra.begin_fill()
    for i in range (2):
        tyra.left(120)
        tyra.forward(size)
    tyra.left(30)
    tyra.circle(size/2, 180)
    tyra.end_fill()

    tyra.right(90)
    tyra.penup()
    tyra.backward(size/2)

dates = ['20.03', '21.03', '22.03', '23.03', '24.01']
exp_rain = [32, 60, 15, 24, 35]

def timeline():
    knot.pendown()
    for elem in screen.turtles():
        elem.forward(50)

    for (date, rain) in zip(dates, exp_rain):
        knot.stamp()
        info.write(date)
        drop(rain)
        for elem in screen.turtles():
            elem.forward(80)



knot.goto(-200, 0)
tyra.goto(-200, 100)
info.goto(-200, -50)
timeline()
